
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MONSHOW.C - Show Screen Field Labels
// 
//
//   DESCRIPTION
//
//   Routines to display the data labels on the screen.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MONSHOW.C_v  $
//   
//      Rev 1.17   15 Dec 1999 14:30:54   phungh
//   Add Counter for msg1092, 1292.  Take out
//   msg1192, 1392 to reflect msgID change
//   in the zodiac s/w 2.57 and later
//   
//      Rev 1.16   08 Dec 1999 16:01:34   phungh
//   Modify to display additional message 
//   counters and Magna data (when Magna is
//   ON)
//   
//      Rev 1.15   27 Apr 1999 14:38:16   phungh
//   Labmon55 : Modification for AMD flash
//   download.  Add display for msg 1180
//   
//      Rev 1.14   21 Apr 1999 11:44:08   phungh
//   Labmon54 : 
//   Add reset for Cnt1050, Cnt1051, Cnt1150
//   Add message display to screen
//   Add msg Cnt display
//   
//      Rev 1.13   Jul 06 1998 09:08:34   BANHND
//   added more DR features
//   
//      Rev 1.10   Jul 09 1997 09:49:40   COLEJ
//   Multiple Changes...
//   
//      Rev 1.8   Feb 25 1997 14:34:26   COLEJ
//   changed procedure for calculating delta positions
//   using matrix  vice a constant number
//   
//      Rev 1.7   Feb 12 1997 16:05:12   COLEJ
//    
//   
//      Rev 1.6   Nov 14 1996 11:25:20   COLEJ
//    
//   
//      Rev 1.5   Sep 03 1996 12:46:20   COLEJ
//    
//   
//      Rev 1.4   Aug 26 1996 18:42:48   COLEJ
//    
//   
//      Rev 1.3   Aug 14 1996 08:49:56   COLEJ
//    
//   
//   
//      Rev 1.1   Aug 14 1996 08:44:02   COLEJ
//   Added msg1108 processing.
//   Changed UTC DATE field to DATE.
//   Changed UTC field to UTC TIME.
//   Deleted UTCNSEC field and moved up other fields.
//   
//      Rev 1.0   13 May 1996 14:52:38   GPSADMIN
//   Initial release to version control.
//    
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <graph.h>
#include <math.h>
#include <string.h>   
#include <sys\timeb.h> 
#include <time.h>

#ifdef __WATCOMC__
#define _ftime ftime
#define _timeb timeb
#endif

#include "LABMON.H"
#include "DISPLAY.H"
#include "MESS_IO.H"
#include "monmisc.h"  
#include "ALM_SEND.H"
#include "EPH_SEND.H"
#include "UTC_SEND.H"
#include "gentypes.h"
#include "zcons.h"
#include "ztypes.h"
#include "util.h"

unsigned long cnt101  = 0, cnt102  = 0, cnt103  = 0, cnt104  = 0, cnt105  = 0;
unsigned long cnt106  = 0, cnt107  = 0, cnt111  = 0, cnt112  = 0, cnt117  = 0;
unsigned long cnt113  = 0, cnt152  = 0, cnt153  = 0, cnt201  = 0, cnt202  = 0;
unsigned long cnt203  = 0, cnt204  = 0, cnt205  = 0, cnt206  = 0, cnt207  = 0;
unsigned long cnt208  = 0, cnt209  = 0, cnt210  = 0, cnt211  = 0, cnt213  = 0;
unsigned long cnt215  = 0, cnt217  = 0, cnt220  = 0, cnt2309 = 0, cnt2319 = 0; 
unsigned long cntnack = 0, cnthcs  = 0, cntdcs  = 0, cntovf  = 0, cntsyn  = 0;
unsigned long cntalm  = 0, cntgga  = 0, cntgll  = 0, cntgsa  = 0, cntgsv  = 0; 
unsigned long cntrmc  = 0, cntvtg  = 0, cntzda  = 0, cntalt  = 0, cntcom  = 0; 
unsigned long cntdgp  = 0, cntinit = 0, cntlog  = 0, cntq    = 0, cntftst = 0, cntgen  = 0; 
unsigned long cnticom = 0, cntidgp = 0, cntzch  = 0, cntncs  = 0, cnterr  = 0;
unsigned long cntrid  = 0, cntilog = 0, cntipro = 0, cntibit = 0, cntbit  = 0;

unsigned long Cnt1000 = 0, Cnt1001 = 0, Cnt1002 = 0, Cnt1003 = 0;
unsigned long Cnt1005 = 0, Cnt1007 = 0, Cnt1008 = 0, Cnt1009 = 0, Cnt1011 = 0, Cnt1012 = 0;
unsigned long Cnt1040 = 0, Cnt1041 = 0, Cnt1042 = 0, Cnt1050 = 0, Cnt1051 = 0;
unsigned long Cnt1070 = 0, Cnt1071 = 0, Cnt1072 = 0, Cnt1075 = 0, Cnt1090 = 0, Cnt1091 = 0;
unsigned long Cnt1092 = 0, Cnt1100 = 0, Cnt1102 = 0, Cnt1106 = 0, Cnt1108 = 0, Cnt1110 = 0;
unsigned long Cnt1117 = 0, Cnt1130 = 0, Cnt1135 = 0, Cnt1136 = 0, Cnt1137 = 0;
unsigned long Cnt1150 = 0, Cnt1160 = 0, Cnt1170 = 0;  
unsigned long Cnt1171 = 0, Cnt1172 = 0, Cnt1173 = 0, Cnt1180 = 0, Cnt1190 = 0, Cnt1191 = 0;
unsigned long Cnt1200 = 0, Cnt1208 = 0, Cnt1210 = 0, Cnt1211 = 0, Cnt1212 = 0;
unsigned long Cnt1213 = 0, Cnt1214 = 0, Cnt1216 = 0, Cnt1217 = 0;
unsigned long Cnt1218 = 0, Cnt1219 = 0, Cnt1220 = 0, Cnt1221 = 0;
unsigned long Cnt1240 = 0, Cnt1241 = 0, Cnt1242 = 0, Cnt1270 = 0, Cnt1292 = 0;
unsigned long Cnt1300 = 0, Cnt1303 = 0, Cnt1304 = 0, Cnt1305 = 0, Cnt1306 = 0, Cnt1310 = 0;
unsigned long Cnt1317 = 0, Cnt1330 = 0, Cnt1331 = 0, Cnt1334 = 0, Cnt1337 = 0, Cnt1350 = 0;
unsigned long Cnt1351 = 0, Cnt1360 = 0, Cnt1380 = 0;
unsigned long CntZLog = 0, CntZQry = 0;
unsigned long CntNav  = 0, CntPnt  = 0;

extern short     cbclear;
extern short     pdclear;
extern tDATATYPE DataType;
extern short     rockwell_link;
extern short     delta;

extern struct _timeb timebuffer; 
extern double        cnttime_ref;
extern short           alm_rate;
extern unsigned long alm_delay;

extern unsigned char msgbuff[MAX_MSG_BUFFER];
extern char          buff[80];
extern unsigned char tx_buff[MAX_TX_BUFFER];
extern double        lat, lon, alt;
extern short         BITTest;
extern short         In_Nav_Mode;
extern short         Auto_2D;
extern FILE          *Alm_FilePtr;
extern double        AltInput;
extern short         cmdline;  
extern short         MainTextColor;  
extern short         MainDataColor;  
extern short         MainBackColor;
extern short         MenuKeysColor;  
extern short         MenuDescColor;  
extern short         MenuBackColor; 
extern double        delta_lat;
extern double        delta_lon;
extern double        delta_alt;   
extern double        ref_lat, ref_lon, ref_alt;

extern tBOOL DEBUG;
extern tBOOL Flag1102;
extern tBOOL OldFlag1102;
extern tBOOL DisplayDRError;
extern tBOOL Display1070;

void init_2D();

typedef struct {
   short   Total_Vis;
   short   Sat_Num[12];
   float Elevation[12];
   float Azimuth[12];
} tSATLIST;

static tSATLIST Sat_List;

void get_visible_sats(void)
{
 short i;

 Sat_List.Total_Vis = get_I16(12);
 for(i=0;i<12;i++)
 {
   if(i < Sat_List.Total_Vis )
   {
    Sat_List.Sat_Num[i] = get_I16(13+5*i);
    Sat_List.Elevation[i] = (float)(R2D*get_F24(14+5*i));
    Sat_List.Azimuth[i] = (float)(R2D*get_F24(16+5*i));
   }
   else
   {
    Sat_List.Sat_Num[i] = 0;
    Sat_List.Elevation[i] = 0.0f;
    Sat_List.Azimuth[i] = 0.0f;
   }
 }
}


void show_BIT_test_labels(void)
{                           
 _settextcolor(MainTextColor);
  
 _settextposition(1,33); _outtext("B.I.T. RESULTS");

 _settextposition(3,1);
 _outtext("SUMMARY:   SYSTEM     ROM     LOW RAM");
 _outtext("     HIGH RAM     SPI     RAM ADDRESS");

 _settextposition(4,1);
 _outtext("            ****     ****       **** ");
 _outtext("       ****      ****        ****");

 _settextposition(6,1);
 _outtext("LOW RAM =  ****     HIGH RAM =  ****     ");
 _outtext("PRE_PROCESSOR RAM =  ****");

 _settextposition(8,1);
 _outtext("      PP SELF    PP WRAP    CODE VCO");
 _outtext("    CAR VCO    CODE GEN    SIG PROC");

 _settextposition(9,1);
 _outtext("CH1    ****       ****        ****  ");
 _outtext("     ****        ****        ****");

 _settextposition(10,1);
 _outtext("CH2    ****       ****        ****  ");
 _outtext("     ****        ****        ****");

 _settextposition(11,1);
 _outtext("CH3    ****       ****        ****  ");
 _outtext("     ****        ****        ****");

 _settextposition(12,1);
 _outtext("CH4    ****       ****        ****  ");
 _outtext("     ****        ****        ****");

 _settextposition(13,1);
 _outtext("CH5    ****       ****        ****  ");
 _outtext("     ****        ****        ****");

 _settextposition(15,1);
 _outtext("INTERRUPT CONTROL: ****   LOW POWER TIME SOURCE: ****   ");
 _outtext("OPTIONS REGISTER: ****");

 _settextposition(17,1);
 _outtext("SERIAL I/O:      TRANS ERRORS =         CHECKSUM ERRORS =     ");
 _settextposition(18,1);
 _outtext("EEPROM:       PROGRAMS ERRORS =         CHECKSUM ERRORS =     ");

 _settextposition(20,1);
 _outtext("LINK ID:");

 _settextposition(21,1);
 _outtext("SOFTWARE VERSION:"); 
 _settextcolor(MainDataColor);

}


void show_BIT_test_results(void)
{
   short i, link_id;

   _settextposition(4,13);      /* Bit 0: System Health */
   if(get_I16(6) & 0x01)_outtext("FAIL");
   else _outtext("PASS");

   _settextposition(4,22);      /* Bit 8: ROM Failure */
   if((get_I16(6)>>8) & 0x01) _outtext("FAIL");
   else _outtext("PASS");

   _settextposition(4,33);      /* Bit 9: Low Order RAM Failure */
   if((get_I16(6)>>8) & 0x02) _outtext("FAIL");
   else _outtext("PASS");

   _settextposition(4,45);      /* Bit 10: High Order RAM Failure */
   if((get_I16(6)>>8) & 0x04) _outtext("FAIL");
   else _outtext("PASS");

   _settextposition(4,55);      /* Bit 11: SPI Failure */
   if((get_I16(6)>>8) & 0x08) _outtext("FAIL");
   else _outtext("PASS");

   _settextposition(4,67);      /* Bit 12: RAM Addressing Failure */
   if((get_I16(6)>>8) & 0x10) _outtext("FAIL");
   else _outtext("PASS");

   _settextposition(6,12);      /* Low Order RAM Pattern Test Result */
   if(get_I16(7) == 0xffff) _outtext("PASS");
   else  _outtext("FAIL");

   _settextposition(6,33);      /* High Order RAM Pattern Test Result */
   if(get_I16(8) == 0xffff) _outtext("PASS");
   else _outtext("FAIL");

   _settextposition(6,63);      /* Pre processor RAM Pattern Test Result */
   if(get_I16(10) == 0xffff) _outtext("PASS");
   else _outtext("FAIL");



   for(i=0;i < 5; i++){

                  /* Pre-Processor Self-Test */

      _settextposition(9+i,8);
      if( msgbuff[16] & (0x01 << i)) _outtext("FAIL");
      else _outtext("PASS");

               /* Pre-Processor Wrap Around Self-Test */

      _settextposition(9+i,19);
      if( msgbuff[17] & (0x01 << i) ) _outtext("FAIL");
      else _outtext("PASS");


               /* Signal Processor Tests; Code VCO */

      _settextposition(9+i,31);
      if( msgbuff[22] & (0x01 << i))_outtext("FAIL");
      else _outtext("PASS");


               /* Signal Processor Tests; Carrier VCO */

      _settextposition(9+i,42);
      if( msgbuff[23] & (0x01 << i)) _outtext("FAIL");
      else _outtext("PASS");

               /* Signal Processor Tests; Code generator */

      _settextposition(9+i,54);
      if( msgbuff[24] & (0x01 << i)) _outtext("FAIL");
      else _outtext("PASS");


               /* Signal Processor Tests; Signal Injection */

      _settextposition(9+i,66);
      if( msgbuff[25] & (0x01 << i)) _outtext("FAIL");
      else _outtext("PASS");

      }

               /* Multi-Function Interface Self Test */

   _settextposition(15,20);     /* Interrupt Controller Test */
   if( msgbuff[20] & 0x01) _outtext("FAIL");
   else  _outtext("PASS");

   _settextposition(15,50);   /* Low Power Timer Test */
   if( msgbuff[21] & 0x01) _outtext("FAIL");
   else _outtext("PASS");

   _settextposition(15,75);   /* Options Register Test */
   if( msgbuff[21] & 0x02) _outtext("FAIL");
   else _outtext("PASS");

   sprintf(buff,"%3d", get_I16(14)); /* Serial Trans. Error Count */
   _settextposition(17,33); _outtext( buff );

   sprintf(buff,"%3d", get_I16(15)); /* Serial Checksum Error Count */
   _settextposition(17,59); _outtext( buff );

   sprintf(buff,"%3d", get_I16(16)); /* EEPROM Programming Error */
   _settextposition(18,33); _outtext( buff );

   sprintf(buff,"%3d", get_I16(17)); /* EEPROM Checksum Error Count */
   _settextposition(18,59); _outtext( buff );


   sprintf(buff,"%c%c%c%c",
      msgbuff[34],msgbuff[35],msgbuff[36],msgbuff[37]);
   _settextposition(20,11); _outtext( buff );
   
   link_id = get_I16(19);
   if(link_id & 0x01) _outtext(" DGPS"); else _outtext(" SPS ONLY");
   if(link_id & 0x02) _outtext(" WITH SV MEASUREMENTS");
   if(link_id & 0x04) _outtext(" WITH POWER MANAGEMENT");

   sprintf(buff,"%.2f", get_F24(20) );
   _settextposition(21,20); _outtext( buff );

   _settextposition( 24,28 ); _outtext("PRESS ANY KEY TO CONTINUE");
}


void message_acknowledgment( short mess_id )
{

   short i;

   if(msgbuff[7] & 0x08){
      sprintf(buff,"%4d ACK  ", mess_id );
      _settextposition(MSGR, MSGC); _outtext( buff );
      
      if(mess_id == 202){
         _clearscreen(_GWINDOW);
         show_BIT_test_labels();
         BITTest = TRUE;
      }
      
      if(mess_id == 205){
         // kill some time before sending next almanac message
         while(alm_delay > (timer() - (short)((18.2/alm_rate)+0.5))){        
            ;  // stall
         }            
         send_almanac();
         alm_delay = timer();        // reset delay counter 
      }
   }
   else{    
      cntnack++;
      sprintf(buff,"%4d NOACK", mess_id );
      _settextposition(MSGR, MSGC); _outtext( buff );
      if(mess_id == 205) for(i=0;i<86;i++)  send_byte(tx_buff[i]);
   }
}
unsigned char pdi (unsigned char buffer) 
{
  short code;
  code = (buffer & 0x00C0) >> 6;
  if (code == 0) return 1; 
  if (code == 1) return 5;
  if (code == 2) return 10;
  if (code == 3) return 20;
  return 0;
}

void show_channels( short os )
{
   char sat;           /* Used For Primary And Secondary Satellite */
   short i;

   os*=2;              // Change offset to bytes

   for( i = 0; i < 5; i++ ){

      _settextposition(CHNR+i,CHNC);

      if(os){
         if( (msgbuff[94 + os + (i*4)] & 0x1) )
         sat = ' ';
         else sat = '*';
         sprintf(buff,"%2d  %2d %c%1d%1d%1d %2d %2d", 
               i+1, 
               msgbuff[92 + os + (i*4)]&0x3f, sat,          
               ((msgbuff[94 + os + (i*4)]&0x18)>>3),                   
               ((msgbuff[94 + os + (i*4)]&0xE0)>>5),    
               ((msgbuff[93 + os + (i*4)]&0x0F)>>1),
             pdi(msgbuff[95 + os + (i*4)]), 
                (msgbuff[95 + os +(i*4)]&0x3F));
         _outtext( buff );
         }

      else{
         sprintf(buff,"%2d  %2d   %1d    %2d", 
               i+1,                                     // channel          
               msgbuff[92 + os + (i*4)]&0x3f,           // sv id
               ((msgbuff[93 + os + (i*4)]&0x0F)>>1),    // state 
               msgbuff[95 + os + (i*4)]);               // c/n0          
         _outtext( buff );
      }
   }


   for( i = 0; i < 5; i++ ){         /* Clear Utility Channels */
      _settextposition(CHNR+i,CHNC-2);
      _outtext(" ");
   }

   if((msgbuff[125 + os]&0x70)>>4){
      _settextposition(CHNR-1+((msgbuff[125 + os]&0x70)>>4),CHNC-2);
      _outtext("*");
   }
}

void show_lla(short offset) 
// Display Lat/Lon/Alt Position Fix, offset Into 
// display position in WGS-84

{
   short     i, j, k;
   char    dir;
   double  x;
   double  del_lat, del_lon, del_alt;
   tGeoPos GeoPos, RefGeoPos;    // strutures for lat/lon/alt
   double  ENU[3];               // used for delta positions  
  
   lat -= delta_lat;             // Convert WGS-84 to local datum by
   lon -= delta_lon;             // subtracting corrections.
   alt -= delta_alt;              

   // determine whether normal or delta position output mode  
   if(!delta){                                          
      x = lat * R2D; 
      if(x < 0.){
         dir = 'S'; 
         x = -x;
      }
      else{    
         dir = 'N';
      }                     
   
      i = (short) x;
      x = (x - i) * 60.;
      j = (short) x;
      x = (x - j) * 10000.;
      k = (short) x;

      sprintf(buff," %c%2d%02d.%04d'",dir, i, j, k);  // lat
      _settextposition(LATR,LATC+4); _outtext(buff);

      x = lon * R2D;
      if(x < 0.){
         dir = 'W';
         x = -x;
      } 
      else{    
         dir = 'E';
      }
   
      i = (short)x;
      x = ( x - i ) * 60.0;
      j = (short)x;
      x = (x - j) * 10000.0;
      k = (short)x;

      sprintf(buff,"%c%3d%02d.%04d'",dir, i, j, k); // LON
      _settextposition(LATR+1,LATC+4);_outtext(buff);

      sprintf(buff,"    %8.1lf", alt);                    // ALT
      _settextposition(LATR+2,LATC+4);_outtext(buff);   
   }
   else{
      // load tGeoPos structs
      GeoPos.lat = lat * R2D;
      GeoPos.lon = lon * R2D;
      GeoPos.alt = alt;
      RefGeoPos.lat = ref_lat;
      RefGeoPos.lon = ref_lon;
      RefGeoPos.alt = ref_alt;
      
      GeoidToENU( GeoPos, RefGeoPos, ENU );  // call function to calculate delta's

      // output delta lat/lon/alt from reference position
      del_lat = ENU[1]; 
      del_lon = ENU[0]; 
      del_alt = alt - ref_alt;               
      
      sprintf(buff,"%12.2f ", del_lat);        // LAT
      _settextposition(LATR,LATC+4); _outtext(buff);

      sprintf(buff,"%12.2f ", del_lon);        // LON
      _settextposition(LATR+1,LATC+4);_outtext(buff);

      sprintf(buff,"%12.2f", del_alt);   // ALT
      _settextposition(LATR+2,LATC+4);_outtext(buff);        
   }
}

void show_navcore_status(short os )
{
   static short auto_2d_sent;         // Keep track of 201 alt hold message
   static short in_nav = 0;
   char       SolutionType[3];      

   os*=2;                           // Change offset to bytes

   // determine nav status  
   strcpy(SolutionType, "   ");
   if(msgbuff[124 + os] & 0x80){         
      // bit 7 - cold start
      strcpy(buff," COLD");
      if(in_nav) printf("\a\a\a");
      in_nav = 0;
      In_Nav_Mode =  0; 
   }   
   else if(!(msgbuff[124 + os] & 0x08)){    
      // !bit 3 - acquisition
      strcpy(buff,"  ACQ");
      if(in_nav) printf("\a\a\a");
      in_nav = 0;
      In_Nav_Mode =  0;
      if(Auto_2D && !auto_2d_sent){
         // Re-init 2d during Loss of Nav
         init_2D();               
         send_msg(tx_buff);
         auto_2d_sent = 1;
      } 
   }   
   else if(msgbuff[124 + os] & 0x02){    
      // bit 1 - altitude used
      strcpy(buff,"   2D");
      SolutionType[1]    = 'A'; 
      if(!in_nav) printf("\a");
      in_nav = 1;
   }                          
   else if(msgbuff[125 + os] & 0x80){    
      // bit 15 - DGPS
      strcpy(buff," DGPS"); 
      SolutionType[2]    = 'D';
      if(!in_nav) printf("\a");
      in_nav = 1;  
      
      // Only set when been in 3D Nav
      In_Nav_Mode = 1;    
      auto_2d_sent = 0; 
      AltInput = alt;
   }   
   else if(msgbuff[124 + os] & 0x08){ 
      // bit 3 - normal 3D navigation
      strcpy(buff,"   3D"); 
      if(!in_nav) printf("\a");
      in_nav = 1; 
      
      // Only set when been in 3D Nav  
      In_Nav_Mode = 1;    
      auto_2d_sent = 0; 
      AltInput = alt;
   }
   else{ 
      strcpy(buff,"     "); 
   }
   _settextposition(MODR,MODC+5);
   _outtext(buff);
   _settextposition(MODR+2,MODC+5);
   _outtext(SolutionType); 
    
   _settextposition(SETR,SETC+6); 
   if(msgbuff[124 + os] & 0x04){
      // altitude hold enabled
      _outtext("A");
   }
   else{
      _outtext(" ");
   } 
}

void show_diff_status( void )
{
   short i, tmp; 
   unsigned short status_3d, status_2d;

    sprintf(buff,"%4d", *(short*)(msgbuff+14));    // Station ID
   _settextposition(DSTR  ,DSTC-6); _outtext(buff);

    sprintf(buff,"%1d", msgbuff[17] >> 5);       // Sequence
   _settextposition(DSTR+1,DSTC-8); _outtext(buff);   
 
    sprintf(buff,"%4d", *(short*)(msgbuff+16) & 0x1FFF);   // Z-count
   _settextposition(DSTR+1,DSTC+2); _outtext(buff);   
   
    sprintf(buff," %1d", *(short*)(msgbuff+18));   // Station Health
   _settextposition(DSTR+2,DSTC+4);  _outtext(buff);
    
    status_3d = *(unsigned short*)(msgbuff+10);
    status_2d = *(unsigned short*)(msgbuff+78);  
    _settextposition(SETR,SETC+7); 
    if(status_3d & 0x8000){
       // DGPS disabled
       _outtext(" ");
    }
    else{
       _outtext("D");
    }
    _settextposition(SETR,SETC+8); 
    if(status_2d & 0x0400){
       // 2D DGPS disabled
       _outtext(" ");
    }
    else{
       _outtext("2");
    }
    
    sprintf(buff,"%04X-%04X", status_3d, status_2d);    // DGPS status
   _settextposition(DSTR+3,DSTC-3); _outtext(buff);

    sprintf(buff,"%9.2f",
      (*(unsigned short*)(msgbuff+20))/1000.0);     // Horizontal Error
   _settextposition(HERR  ,HERC+5);  _outtext(buff);

    sprintf(buff,"%9.2f",
      (*(unsigned short*)(msgbuff+22))/1000.0);     // Vertical Error
   _settextposition(HERR+1,HERC+5);  _outtext(buff);

   for( i = 0; i < 5; i++ ){      
   
      tmp = get_I16(16 + (i*2));

      _settextposition(DGSR+i,DGSC);

      // "SVID EPH CORR UDRE LH BH BO TO SA IODE" //
      // "CORR UDRE TO EPH LH RH RO SA IODE" //
      
      sprintf(buff,"%1d%1d%1d%1d%1d%1d%1d%1d%1d",
      (tmp >>  6) & 0x01,
      (tmp >>  7) & 0x01,
      (tmp >>  8) & 0x01,
      (tmp >>  9) & 0x01,
      (tmp >> 10) & 0x01,
      (tmp >> 11) & 0x01,
      (tmp >> 12) & 0x01,
      (tmp >> 13) & 0x01,
      (tmp >> 14) & 0x01);

       _outtext( buff );
      }
}

void show_screen_titles(void)
{
   int i;
   
   _settextcolor(MainTextColor);
 
   if(DataType == Z_BINARY){
   _settextposition(MODR  ,MODC  ); _outtext("STAT ");
   _settextposition(MODR+1,MODC  ); _outtext("INVAL");
   _settextposition(MODR+2,MODC  ); _outtext("TYPE ");
   }
   else if(DataType == NC_BINARY){ 
   _settextposition(MODR  ,MODC  ); _outtext("STAT ");
   _settextposition(MODR+1,MODC  ); _outtext("FOM  ");
   _settextposition(MODR+2,MODC  ); _outtext("TYPE "); 
   }
   else{
   _settextposition(MODR  ,MODC  ); _outtext("STAT ");
   _settextposition(MODR+1,MODC  ); _outtext("FIX  ");
   _settextposition(MODR+2,MODC  ); _outtext("QUAL ");      
   }
   if(DataType == NC_BINARY){
   _settextposition(SETR  ,SETC  ); _outtext("ENAB ");
   _settextposition(SETR+1,SETC  ); _outtext("PMGMT"); 
   _settextposition(SETR+2,SETC  ); _outtext("RATE ");   
   _settextposition(SETR+3,SETC  ); _outtext("ATO   ");
   _settextposition(SETR+4,SETC  ); _outtext("LPTO  ");  
   _settextposition(SETR+6,SETC  ); _outtext("CORR  ");   
   }
   else{
   _settextposition(SETR  ,SETC  ); _outtext("VALID");
   _settextposition(SETR+1,SETC  ); _outtext("ENAB "); 
   _settextposition(SETR+2,SETC  ); _outtext("PLAT "); 
//   _settextposition(SETR+3,SETC  ); _outtext("ANTYPE");
   _settextposition(SETR+4,SETC  ); _outtext("COLDTO");    
   _settextposition(SETR+6,SETC  ); _outtext("MEHPE");
   _settextposition(SETR+7,SETC  ); _outtext("MEVPE");    
  }
   _settextposition(SETR+5,SETC  ); _outtext("DGPSTO");    
  
   _settextposition(DOPR-2,DOPC  ); _outtext("SATS");
   _settextposition(DOPR-1,DOPC  ); _outtext("NVIS");  
   _settextposition(DOPR  ,DOPC  ); _outtext("MASK");
   _settextposition(DOPR+1,DOPC  ); _outtext("GDOP");
   _settextposition(DOPR+2,DOPC  ); _outtext("PDOP");
   _settextposition(DOPR+3,DOPC  ); _outtext("HDOP");
   _settextposition(DOPR+4,DOPC  ); _outtext("VDOP");
   _settextposition(DOPR+5,DOPC  ); _outtext("TDOP");
   _settextposition(DOPR+6,DOPC  ); _outtext("TCN0");
   
   _settextposition(TIMR  ,TIMC   ); _outtext("DATE");
   _settextposition(TIMR+1,TIMC   ); _outtext("UTC  "); 
//   _settextposition(TIMR+2,TIMC   ); _outtext("UTCNSEC");
   _settextposition(TIMR+2,TIMC   ); _outtext("GPSSEC");
   _settextposition(TIMR+3,TIMC   ); _outtext("GPSNSEC");
   _settextposition(TIMR+4,TIMC   ); _outtext("WEEK");
   _settextposition(TIMR+4,TIMC+10); _outtext("DAY");   
   _settextposition(TIMR+5,TIMC   ); _outtext("SETTIME"); 
   _settextposition(TIMR+6,TIMC   ); _outtext("SEQ");   
   _settextposition(TIMR+6,TIMC+10); _outtext("M"); 

   _settextposition(CBER  ,CBEC  );  _outtext("CBE");
   _settextposition(CBER+1,CBEC  );  _outtext("CBSIG");
   _settextposition(CBER+2,CBEC  );  _outtext("CDE");
   _settextposition(CBER+3,CBEC  );  _outtext("CDSIG");  
   
   _settextposition(RAMR,RAMC  );  _outtext("RAMER");
   _settextposition(DRER,DREC  );  _outtext("DRERR");  
   
// HP //
   if(!Display1070) {
   	_settextposition(MAGR,MAGC  );  _outtext("MAGNA");
   	_settextposition(MAGR+1,MAGC);  _outtext("CNO");
   	_settextposition(MAGR+2,MAGC);  _outtext("OFFPWR");
   	_settextposition(MAGR+3,MAGC);  _outtext("RTCINT");
   }
   
    
   if(DEBUG){ // 1102 data fields 
      _settextposition(CBDR  ,CBDC-1);  _outtext("CB    ");
      _settextposition(CBDR+1,CBDC-1);  _outtext("CD    ");
      _settextposition(CBDR+2,CBDC-1);  _outtext("TMP   ");
      //_settextposition(CBDR+3,CBDC  );  _outtext("TMPR");
      _settextposition(CBDR+3,CBDC-1);  _outtext("COUNT "); 
   } // end if debug

   _settextposition(LATR  ,LATC  ); _outtext("LAT");  
   _settextposition(LATR+1,LATC  ); _outtext("LON");  
   _settextposition(LATR+2,LATC  ); _outtext("ALT");  
 
   if (!DisplayDRError) {
     _settextposition(POSR  ,POSC  ); _outtext("POSX");  
     _settextposition(POSR+1,POSC  ); _outtext("POSY");  
     _settextposition(POSR+2,POSC  ); _outtext("POSZ"); 
   } else {
     _settextposition(POSR  ,POSC  ); _outtext("GPSH");  
     _settextposition(POSR+1,POSC  ); _outtext("GPSV");  
     _settextposition(POSR+2,POSC  ); _outtext("GPSP"); 
   }
    
   _settextposition(GEOR  ,GEOC  ); _outtext("GSEP");  
   _settextposition(GEOR+1,GEOC  ); _outtext("DATUM");  
   _settextposition(GEOR+2,GEOC  ); _outtext("POLAR");  
  
   if ((DataType == NC_BINARY) || (DataType == NC_NMEA)){
      _settextposition(VELR  ,VELC  ); _outtext("VELE");
      _settextposition(VELR+1,VELC  ); _outtext("VELN");
      _settextposition(VELR+2,VELC  ); _outtext("VELU");
   }
   else{
     if (!DisplayDRError) {
      _settextposition(VELR  ,VELC  ); _outtext("VELX");
      _settextposition(VELR+1,VELC  ); _outtext("VELY");
      _settextposition(VELR+2,VELC  ); _outtext("VELZ"); 
     } else {
      _settextposition(VELR  ,VELC - 2); _outtext("DRH");
      _settextposition(VELR+1,VELC - 2); _outtext("DRV");
      _settextposition(VELR+2,VELC - 2); _outtext("DRP"); 
     }
      
      //_settextposition(VELR  ,SPDC  ); _outtext("ATA ");
      //_settextposition(VELR+1,SPDC  ); _outtext("XTA ");
      //_settextposition(VELR+2,SPDC  ); _outtext("VA  ");
   }
   
   if (DataType == Z_BINARY){
      _settextposition(DRFR  ,DRFC  ); _outtext("DRFL");
      _settextposition(DRFR+1,DRFC  ); _outtext("DRHR");
      _settextposition(DRFR+2,DRFC  ); _outtext("DRST"); 
      _settextposition(DRSR  ,DRSC  ); _outtext("DRS");
      _settextposition(DRSR+1,DRSC  ); _outtext("DRT");
      _settextposition(DRSR+2,DRSC  ); _outtext("GFTST");
   }

   _settextposition(SOGR  ,SOGC  ); _outtext("SOG");
   _settextposition(SOGR+1,SOGC  ); _outtext("COG");
   _settextposition(SOGR+2,SOGC  ); _outtext("MAG");  
   _settextposition(SOGR+3,SOGC  ); _outtext("COGE");  
   
   _settextposition(SPDR  ,SPDC  ); _outtext("SPD");
   _settextposition(SPDR+1,SPDC  ); _outtext("CLM");
   _settextposition(SPDR+2,SPDC  ); _outtext("WDT");

   _settextposition(PRTR  ,PRTC  ); _outtext("PORT1");
   _settextposition(PRTR+1,PRTC  ); _outtext("PORT2");
   _settextposition(PRTR+2,PRTC  ); _outtext("WCNT ");

   if(rockwell_link){
     _settextposition(CHNR-1,CHNC);_outtext("CH  SV TRK PD CN");
   } 
   else{
      if((DataType == Z_BINARY) || (DataType == Z_NMEA)){  // zodiac
     _settextposition(CHNR-1,CHNC);_outtext("CH  SV  UVEC  CN");
      }
      else{  // navcore
     _settextposition(CHNR-1,CHNC);_outtext("CH  SV  TRK   CN");
      }
   }
   _settextposition(VISR-1,VISC); _outtext("SV EL AZI IODE");     
   _settextposition(VISR+12,VISC); _outtext("XSV"); 
  
   if((DataType == NC_BINARY) || (DataType == NC_NMEA)){  // navcore
      _settextposition(CPMR-1,CPMC  ); _outtext("CODE ERPFLBC"); 
   }
   else{  // zodiac
      if(DEBUG){ // 1102 data fields
        
        // check if Flag1102 has changed its state
		if(OldFlag1102 != Flag1102) {
			for(i=0; i<GI_NUM_HW_CHAN+1; i++) {
           	   _settextposition(CPMR-1+i,CPMC-1);  
               _outtext("                               "); 
               _outtext("                               ");
            }
            OldFlag1102 = Flag1102;
        } 
        
        // display header for 1102 data
        if(Flag1102) {
           _settextposition(CPMR-1,CPMC-1); _outtext("CARRIERPHASE");
        }
        // display header for 1191 data
        else {
           _settextposition(CPMR-1,CPMC-1);  _outtext("SNR"); 
        }

      } // end if debug
   }

   if(DEBUG){ // 1102 data fields 
      
      // display header for 1102 data
      if(Flag1102) {
         _settextposition(PRMR-1,PRMC-2); _outtext("PSEUDO RANGE  RANGRATE");
         _settextposition(CPBR-1,CPBC-2); _outtext("CSW1 CSW2");
         _settextposition(CPBR-1,CPBC+8); _outtext("IODE");
         //_settextposition(CPBR-1,CPBC+1); _outtext("PHASE BIAS");
      }
      // display header for 1191 data
      else {
         _settextposition(PRMR-1,PRMC-4); _outtext("RANGE   UNC   RATE   UNC");
         _settextposition(MATR,MATC); _outtext("N USED");
         _settextposition(MATR+1,MATC); _outtext("T20");
         _settextposition(MATR+2,MATC); _outtext("GPSREF");
         _settextposition(MATR+3,MATC); _outtext("SEQ");
         _settextposition(MATR+9,MATC); _outtext("VALIDITY");
         _settextposition(MATR+10,MATC); _outtext("LAFC TXCD");
         _settextposition(MATR+5,MATC); _outtext("OFFSET");
         _settextposition(MATR+6,MATC); _outtext("XOERR");
         _settextposition(MATR+7,MATC); _outtext("XO_UNC");
      }  
   } // end if debug


   _settextposition(MSGR  ,MSGC-8); _outtext("MESSAGE");
        
   if((DataType == NC_BINARY) || (DataType == NC_NMEA)){
      _settextposition(DSTR  ,DSTC-12); _outtext("STNID");
      _settextposition(DSTR+1,DSTC-12); _outtext("SEQ");  
      _settextposition(DSTR+1,DSTC- 5); _outtext("ZCOUNT");  
      _settextposition(DSTR+2,DSTC-12); _outtext("COM"); 
      _settextposition(DSTR  ,DSTC- 1); _outtext("AGE");
      _settextposition(DSTR+2,DSTC   ); _outtext("HLTH"); 
      _settextposition(DSTR+3,DSTC-12); _outtext("STATUS"); 
   }
   else if((DataType == Z_BINARY) || (DataType == Z_NMEA)){
      _settextposition(DSTR  ,DSTC-12); _outtext("STNID");
      _settextposition(DSTR  ,DSTC- 1); _outtext("HLTH");
      _settextposition(DSTR+1,DSTC-12); _outtext("AGE");
      _settextposition(DSTR+2,DSTC-12); _outtext("STATUS");
   }
   
   if(cmdline == 100){

        _settextposition(RTHR  ,RTHC   ); _outtext("TYPE"); 
        _settextposition(RTHR+1,RTHC   ); _outtext("ID"); 
        _settextposition(RTHR  ,RTHC+ 8); _outtext("ZCNT");
        _settextposition(RTHR+1,RTHC+18); _outtext("HEALTH");  
        _settextposition(RTHR  ,RTHC+18); _outtext("SEQ"); 
        _settextposition(RTHR+1,RTHC+18); _outtext("LEN"); 
              
        _settextposition(RTNR  ,RTNC- 4); _outtext("NO1"); 
        _settextposition(RTNR+1,RTNC- 4); _outtext("NO5"); 
        _settextposition(RTNR  ,RTNC+ 4); _outtext("NO2"); 
        _settextposition(RTNR+1,RTNC+ 4); _outtext("NO9");    
               
        _settextposition(RTER  ,RTEC- 8); _outtext("DATAERR"); 
        _settextposition(RTER+1,RTEC- 8); _outtext("FILLERR"); 
        _settextposition(RTER  ,RTEC+ 5); _outtext("PARERR"); 
        _settextposition(RTER+1,RTEC+ 5); _outtext("STNERR");  
        _settextposition(RTER  ,RTEC+17); _outtext("SEQERR"); 
        _settextposition(RTER+1,RTEC+17); _outtext("ZCTERR"); 
         
      _settextposition(TY1R-1,TY1C);
      _outtext("SV U S     PRC     RRC  IODE");    
      _settextposition(TY2R-1,TY2C);
      _outtext("SV U S    DPRC    DRRC  IODE"); 
      _settextposition(TY5R-1,TY5C); 
      _outtext("SV L D CN H L T"); 
     
   }                                                              
  
   _settextposition(HERR  ,HERC); _outtext("EHPE");
   _settextposition(HERR+1,HERC); _outtext("EVPE");
   _settextposition(HERR+2,HERC); _outtext("ETE");
   _settextposition(HERR+3,HERC); _outtext("EHVE");

   if((DataType == Z_BINARY) || (DataType == Z_NMEA)){   // zodiac 
      if(Flag1102) 
      {
         _settextposition(DGSR-1,DGSC); _outtext("SV ECULRTI");
      }
   }
   else{
      _settextposition(DGSR-1,DGSC); _outtext("ECULROTSI");
   }

   _settextcolor(MainDataColor);

}


void show_time(double t) /* Display Time Of Week  */
{

   short   hour, minute, second, msec;

   hour = (short)(t / 3600.0);       
   t -= (hour * 3600.0);
   minute = (short)(t / 60.0);
   t -= (minute * 60.0);
   second = (short)(t);
   t -= (second * 1.0);
   msec = (short)(t*1000.0);

   sprintf(buff,"%3d:%02d:%02d.%03d",  hour, minute, second, msec);
   _outtext( buff );

}

void show_Velocity( short os)
{
   double spd, heading;
   double E_vel, N_vel, U_vel;

   E_vel = get_F24(28 + os);
   N_vel = get_F24(30 + os);
   U_vel = get_F24(32 + os);

   spd = sqrt((E_vel * E_vel) + (N_vel * N_vel));
   // spd /= 0.44704;            // Convert M/sec to MPH
   spd *= 1.836735;             // Convert M/sec to knots
   if (spd != 0.0) heading = (atan2(E_vel, N_vel)) * R2D;
   else heading = 0.0;

   if (heading < 0.0) heading += 360.0;

   sprintf(buff,"%6.2f", spd);                    // speed over ground
   _settextposition(SOGR  ,SOGC+4); _outtext(buff);
   sprintf(buff," %5.1f", heading);           // course over ground
   _settextposition(SOGR+1,SOGC+4); _outtext(buff);
                                                       
   sprintf(buff,"%6.2f", E_vel);              // ENU velocity
   _settextposition(VELR  ,VELC+4); _outtext(buff);
   sprintf(buff,"%6.2f", N_vel);
   _settextposition(VELR+1,VELC+4); _outtext(buff);
   sprintf(buff,"%6.2f", U_vel);
   _settextposition(VELR+2,VELC+4); _outtext(buff);
}

void show_visible_sats(void)
{
   short i;

   sprintf(buff,"%2d", Sat_List.Total_Vis);
   _settextposition(DOPR-1, DOPC+9); 
   _outtext(buff);
         
   for(i=0;i<11;i++) {
      _settextposition(VISR+i,VISC);
      if(i < Sat_List.Total_Vis ){
         sprintf(buff,"%2d  %4.1f %4.0f",
         Sat_List.Sat_Num[i],
         Sat_List.Elevation[i],
         Sat_List.Azimuth[i] );
      }
      else sprintf(buff,"               ");
         _outtext(buff);
      }

}

void show_count(void)      
{
   double cnttime;
   double systime;
   short  row, col;
   extern short TERMINAL;
   
   // check terminal
   if(TERMINAL) return;
   
   // check whether menu is on
   if(menu_on) return;
   
   // compute count time as offset between system time and ref time
   _ftime(&timebuffer);
   systime = (double) (timebuffer.time + timebuffer.millitm * .001);     
   cnttime = systime - cnttime_ref; 
 
   // print titles first   
   row = CNTR;
   col = CNTC+1;
   _settextposition(row++, col);
   _settextcolor(MainTextColor);  
   sprintf(buff,"DTIME"); _outtext(buff);  
   _settextposition(row++, col);
          
    if(DataType == NC_BINARY){
      // binary message counters
      if(cnt101) {sprintf(buff,"101  "); ShowText(buff, row++, col);}
      if(cnt102) {sprintf(buff,"102  "); ShowText(buff, row++, col);}     
      if(cnt103) {sprintf(buff,"103  "); ShowText(buff, row++, col);}      
      if(cnt104) {sprintf(buff,"104  "); ShowText(buff, row++, col);}  
      if(cnt105) {sprintf(buff,"105  "); ShowText(buff, row++, col);}      
      if(cnt106) {sprintf(buff,"106  "); ShowText(buff, row++, col);}        
      if(cnt107) {sprintf(buff,"107  "); ShowText(buff, row++, col);}       
      if(cnt111) {sprintf(buff,"111  "); ShowText(buff, row++, col);}       
      if(cnt112) {sprintf(buff,"112  "); ShowText(buff, row++, col);}       
      if(cnt113) {sprintf(buff,"113  "); ShowText(buff, row++, col);}  
      if(cnt117) {sprintf(buff,"117  "); ShowText(buff, row++, col);}  
      if(cnt152) {sprintf(buff,"152  "); ShowText(buff, row++, col);}         
      if(cnt153) {sprintf(buff,"153  "); ShowText(buff, row++, col);}  
      if(cnt201) {sprintf(buff,"201  "); ShowText(buff, row++, col);}      
      if(cnt202) {sprintf(buff,"202  "); ShowText(buff, row++, col);}      
      if(cnt203) {sprintf(buff,"203  "); ShowText(buff, row++, col);}      
      if(cnt204) {sprintf(buff,"204  "); ShowText(buff, row++, col);}       
      if(cnt205) {sprintf(buff,"205  "); ShowText(buff, row++, col);}       
      if(cnt206) {sprintf(buff,"206  "); ShowText(buff, row++, col);}       
      if(cnt207) {sprintf(buff,"207  "); ShowText(buff, row++, col);}  
      if(cnt208) {sprintf(buff,"208  "); ShowText(buff, row++, col);}       
      if(cnt209) {sprintf(buff,"209  "); ShowText(buff, row++, col);}       
      if(cnt210) {sprintf(buff,"210  "); ShowText(buff, row++, col);}        
      if(cnt211) {sprintf(buff,"211  "); ShowText(buff, row++, col);}      
      if(cnt213) {sprintf(buff,"213  "); ShowText(buff, row++, col);}       
      if(cnt215) {sprintf(buff,"215  "); ShowText(buff, row++, col);}       
      if(cnt217) {sprintf(buff,"217  "); ShowText(buff, row++, col);}       
      if(cnt220) {sprintf(buff,"220  "); ShowText(buff, row++, col);}        
      if(cnt2309){sprintf(buff,"2309 "); ShowText(buff, row++, col);}  
      if(cnt2319){sprintf(buff,"2319 "); ShowText(buff, row++, col);}
      if(cntnack){sprintf(buff,"NOACK"); ShowText(buff, row++, col);} 
   }
   else if((DataType == NC_NMEA) || (DataType == Z_NMEA)){
      // nmea message counters
      if(cntalm) {sprintf(buff,"ALM  "); ShowText(buff, row++, col);}       
      if(cntgga) {sprintf(buff,"GGA  "); ShowText(buff, row++, col);}        
      if(cntgll) {sprintf(buff,"GLL  "); ShowText(buff, row++, col);}  
      if(cntgsa) {sprintf(buff,"GSA  "); ShowText(buff, row++, col);} 
      if(cntgsv) {sprintf(buff,"GSV  "); ShowText(buff, row++, col);} 
      if(cntrmc) {sprintf(buff,"RMC  "); ShowText(buff, row++, col);}        
      if(cntvtg) {sprintf(buff,"VTG  "); ShowText(buff, row++, col);}  
      if(cntzda) {sprintf(buff,"ZDA  "); ShowText(buff, row++, col);} 
      if(cntalt) {sprintf(buff,"ALT  "); ShowText(buff, row++, col);}    
      if(cntbit) {sprintf(buff,"BIT  "); ShowText(buff, row++, col);}                           
      if(cntcom) {sprintf(buff,"COM  "); ShowText(buff, row++, col);}    
      if(cntdgp) {sprintf(buff,"DGP  "); ShowText(buff, row++, col);}    
      if(cntinit){sprintf(buff,"INIT "); ShowText(buff, row++, col);}    
      if(cntlog) {sprintf(buff,"LOG  "); ShowText(buff, row++, col);}    
      if(cntzch) {sprintf(buff,"ZCH  "); ShowText(buff, row++, col);}    
      if(cnterr) {sprintf(buff,"ERR  "); ShowText(buff, row++, col);}    
      if(cntrid) {sprintf(buff,"RID  "); ShowText(buff, row++, col);}    
      if(cntq)   {sprintf(buff,"Q    "); ShowText(buff, row++, col);} 
      if(cntftst){sprintf(buff,"FTST "); ShowText(buff, row++, col);} 
      if(cntgen) {sprintf(buff,"GEN  "); ShowText(buff, row++, col);}
      if(cntibit){sprintf(buff,"IBIT "); ShowText(buff, row++, col);}                           
      if(cnticom){sprintf(buff,"ICOM "); ShowText(buff, row++, col);}
      if(cntidgp){sprintf(buff,"IDGP "); ShowText(buff, row++, col);}                           
      if(cntilog){sprintf(buff,"ILOG "); ShowText(buff, row++, col);}                           
      if(cntipro){sprintf(buff,"IPRO "); ShowText(buff, row++, col);}                           
      if(cntncs) {sprintf(buff,"NCSUM"); ShowText(buff, row++, col);}
   }
   else if(DataType == Z_BINARY){
      if(Cnt1000){sprintf(buff,"1000 "); ShowText(buff, row++, col);}
      if(Cnt1001){sprintf(buff,"1001 "); ShowText(buff, row++, col);}
      if(Cnt1002){sprintf(buff,"1002 "); ShowText(buff, row++, col);}
      if(Cnt1003){sprintf(buff,"1003 "); ShowText(buff, row++, col);}
      if(Cnt1005){sprintf(buff,"1005 "); ShowText(buff, row++, col);}
      if(Cnt1007){sprintf(buff,"1007 "); ShowText(buff, row++, col);}
      if(Cnt1008){sprintf(buff,"1008 "); ShowText(buff, row++, col);}
      if(Cnt1009){sprintf(buff,"1009 "); ShowText(buff, row++, col);}
      if(Cnt1011){sprintf(buff,"1011 "); ShowText(buff, row++, col);}
      if(Cnt1012){sprintf(buff,"1012 "); ShowText(buff, row++, col);}
      if(Cnt1040){sprintf(buff,"1040 "); ShowText(buff, row++, col);}
      if(Cnt1041){sprintf(buff,"1041 "); ShowText(buff, row++, col);}
      if(Cnt1042){sprintf(buff,"1042 "); ShowText(buff, row++, col);}
      if(Cnt1050){sprintf(buff,"1050 "); ShowText(buff, row++, col);}
      if(Cnt1051){sprintf(buff,"1051 "); ShowText(buff, row++, col);}
      if(Cnt1070){sprintf(buff,"1070 "); ShowText(buff, row++, col);}
      if(Cnt1071){sprintf(buff,"1071 "); ShowText(buff, row++, col);}
      if(Cnt1072){sprintf(buff,"1072 "); ShowText(buff, row++, col);}
      if(Cnt1075){sprintf(buff,"1075 "); ShowText(buff, row++, col);}
      if(Cnt1090){sprintf(buff,"1090 "); ShowText(buff, row++, col);}
      if(Cnt1091){sprintf(buff,"1091 "); ShowText(buff, row++, col);}
      if(Cnt1092){sprintf(buff,"1092 "); ShowText(buff, row++, col);}
      if(Cnt1100){sprintf(buff,"1100 "); ShowText(buff, row++, col);}
      if(Cnt1102){sprintf(buff,"1102 "); ShowText(buff, row++, col);}
      if(Cnt1106){sprintf(buff,"1106 "); ShowText(buff, row++, col);}
      if(Cnt1108){sprintf(buff,"1108 "); ShowText(buff, row++, col);}
      if(Cnt1110){sprintf(buff,"1110 "); ShowText(buff, row++, col);}
      if(Cnt1117){sprintf(buff,"1117 "); ShowText(buff, row++, col);}
      if(Cnt1130){sprintf(buff,"1130 "); ShowText(buff, row++, col);}
      if(Cnt1135){sprintf(buff,"1135 "); ShowText(buff, row++, col);}
      if(Cnt1136){sprintf(buff,"1136 "); ShowText(buff, row++, col);}
      if(Cnt1137){sprintf(buff,"1137 "); ShowText(buff, row++, col);}
      if(Cnt1150){sprintf(buff,"1150 "); ShowText(buff, row++, col);}
      if(Cnt1160){sprintf(buff,"1160 "); ShowText(buff, row++, col);}
      if(Cnt1170){sprintf(buff,"1170 "); ShowText(buff, row++, col);}
      if(Cnt1171){sprintf(buff,"1171 "); ShowText(buff, row++, col);}
      if(Cnt1172){sprintf(buff,"1172 "); ShowText(buff, row++, col);}
      if(Cnt1173){sprintf(buff,"1173 "); ShowText(buff, row++, col);}
      if(Cnt1180){sprintf(buff,"1180 "); ShowText(buff, row++, col);}
      if(Cnt1190){sprintf(buff,"1190 "); ShowText(buff, row++, col);}
      if(Cnt1191){sprintf(buff,"1191 "); ShowText(buff, row++, col);}
// take out because of msgID changed 1192-->1092      if(Cnt1192){sprintf(buff,"1192 "); ShowText(buff, row++, col);}
      if(Cnt1200){sprintf(buff,"1200 "); ShowText(buff, row++, col);}
      if(Cnt1208){sprintf(buff,"1208 "); ShowText(buff, row++, col);}
      if(Cnt1210){sprintf(buff,"1210 "); ShowText(buff, row++, col);}
      if(Cnt1211){sprintf(buff,"1211 "); ShowText(buff, row++, col);}
      if(Cnt1212){sprintf(buff,"1212 "); ShowText(buff, row++, col);}
      if(Cnt1213){sprintf(buff,"1213 "); ShowText(buff, row++, col);}
      if(Cnt1214){sprintf(buff,"1214 "); ShowText(buff, row++, col);}
      if(Cnt1216){sprintf(buff,"1216 "); ShowText(buff, row++, col);}
      if(Cnt1217){sprintf(buff,"1217 "); ShowText(buff, row++, col);}
      if(Cnt1218){sprintf(buff,"1218 "); ShowText(buff, row++, col);}
      if(Cnt1219){sprintf(buff,"1219 "); ShowText(buff, row++, col);}
      if(Cnt1220){sprintf(buff,"1220 "); ShowText(buff, row++, col);}
      if(Cnt1240){sprintf(buff,"1240 "); ShowText(buff, row++, col);}
      if(Cnt1241){sprintf(buff,"1241 "); ShowText(buff, row++, col);}
      if(Cnt1242){sprintf(buff,"1242 "); ShowText(buff, row++, col);}
      if(Cnt1270){sprintf(buff,"1270 "); ShowText(buff, row++, col);}
      if(Cnt1292){sprintf(buff,"1292 "); ShowText(buff, row++, col);}
      if(Cnt1300){sprintf(buff,"1300 "); ShowText(buff, row++, col);}
      if(Cnt1303){sprintf(buff,"1303 "); ShowText(buff, row++, col);}
      if(Cnt1304){sprintf(buff,"1304 "); ShowText(buff, row++, col);}
      if(Cnt1305){sprintf(buff,"1305 "); ShowText(buff, row++, col);}
      if(Cnt1306){sprintf(buff,"1306 "); ShowText(buff, row++, col);}
      if(Cnt1310){sprintf(buff,"1310 "); ShowText(buff, row++, col);}
      if(Cnt1317){sprintf(buff,"1317 "); ShowText(buff, row++, col);}
      if(Cnt1330){sprintf(buff,"1330 "); ShowText(buff, row++, col);}
      if(Cnt1331){sprintf(buff,"1331 "); ShowText(buff, row++, col);}
      if(Cnt1334){sprintf(buff,"1334 "); ShowText(buff, row++, col);}
      if(Cnt1337){sprintf(buff,"1337 "); ShowText(buff, row++, col);}
      if(Cnt1350){sprintf(buff,"1350 "); ShowText(buff, row++, col);}
      if(Cnt1351){sprintf(buff,"1351 "); ShowText(buff, row++, col);}
      if(Cnt1360){sprintf(buff,"1360 "); ShowText(buff, row++, col);}
      if(Cnt1380){sprintf(buff,"1380 "); ShowText(buff, row++, col);}
// take out becase of msgID changed 1392-->1292      if(Cnt1392){sprintf(buff,"1392 "); ShowText(buff, row++, col);}
      if(CntZQry){sprintf(buff,"QUERY"); ShowText(buff, row++, col);}
      if(CntZLog){sprintf(buff,"LOG  "); ShowText(buff, row++, col);}
   } 
   if(cnthcs) {sprintf(buff,"HCSUM"); ShowText(buff, row++, col);} 
   if(cntdcs) {sprintf(buff,"DCSUM"); ShowText(buff, row++, col);}
   if(cntovf) {sprintf(buff,"BUFOV"); ShowText(buff, row++, col);}   
   if(cntsyn) {sprintf(buff,"SYNER"); ShowText(buff, row++, col);}  

   // show message count 
   row = CNTR;
   col = CNTC+7;
   _settextposition(row++, col);
   _settextcolor(MainDataColor);  
   sprintf(buff,"  %8.3f", cnttime); _outtext(buff); 

   _settextposition(row++, col);
   if(DataType == NC_BINARY){
      // binary message counters
      if(cnt101) {sprintf(buff,"%11lu", cnt101); ShowText(buff, row++, col);}   
      if(cnt102) {sprintf(buff,"%11lu", cnt102); ShowText(buff, row++, col);}  
      if(cnt103) {sprintf(buff,"%11lu", cnt103); ShowText(buff, row++, col);}   
      if(cnt104) {sprintf(buff,"%11lu", cnt104); ShowText(buff, row++, col);}
      if(cnt105) {sprintf(buff,"%11lu", cnt105); ShowText(buff, row++, col);}  
      if(cnt106) {sprintf(buff,"%11lu", cnt106); ShowText(buff, row++, col);}  
      if(cnt107) {sprintf(buff,"%11lu", cnt107); ShowText(buff, row++, col);}   
      if(cnt111) {sprintf(buff,"%11lu", cnt111); ShowText(buff, row++, col);}   
      if(cnt112) {sprintf(buff,"%11lu", cnt112); ShowText(buff, row++, col);}   
      if(cnt113) {sprintf(buff,"%11lu", cnt113); ShowText(buff, row++, col);}   
      if(cnt117) {sprintf(buff,"%11lu", cnt117); ShowText(buff, row++, col);}
      if(cnt152) {sprintf(buff,"%11lu", cnt152); ShowText(buff, row++, col);}    
      if(cnt153) {sprintf(buff,"%11lu", cnt153); ShowText(buff, row++, col);}
      if(cnt201) {sprintf(buff,"%11lu", cnt201); ShowText(buff, row++, col);}  
      if(cnt202) {sprintf(buff,"%11lu", cnt202); ShowText(buff, row++, col);}  
      if(cnt203) {sprintf(buff,"%11lu", cnt203); ShowText(buff, row++, col);}
      if(cnt204) {sprintf(buff,"%11lu", cnt204); ShowText(buff, row++, col);}   
      if(cnt205) {sprintf(buff,"%11lu", cnt205); ShowText(buff, row++, col);}   
      if(cnt206) {sprintf(buff,"%11lu", cnt206); ShowText(buff, row++, col);}   
      if(cnt207) {sprintf(buff,"%11lu", cnt207); ShowText(buff, row++, col);}
      if(cnt208) {sprintf(buff,"%11lu", cnt208); ShowText(buff, row++, col);}   
      if(cnt209) {sprintf(buff,"%11lu", cnt209); ShowText(buff, row++, col);}   
      if(cnt210) {sprintf(buff,"%11lu", cnt210); ShowText(buff, row++, col);}    
      if(cnt211) {sprintf(buff,"%11lu", cnt211); ShowText(buff, row++, col);}   
      if(cnt213) {sprintf(buff,"%11lu", cnt213); ShowText(buff, row++, col);}    
      if(cnt215) {sprintf(buff,"%11lu", cnt215); ShowText(buff, row++, col);}    
      if(cnt217) {sprintf(buff,"%11lu", cnt217); ShowText(buff, row++, col);}   
      if(cnt220) {sprintf(buff,"%11lu", cnt220); ShowText(buff, row++, col);}    
      if(cnt2309){sprintf(buff,"%11lu",cnt2309); ShowText(buff, row++, col);}
      if(cnt2319){sprintf(buff,"%11lu",cnt2319); ShowText(buff, row++, col);}
      if(cntnack){sprintf(buff,"%11lu",cntnack); ShowText(buff, row++, col);}    
   }
   else if ((DataType == NC_NMEA) || (DataType == Z_NMEA)){
      // nmea message counters     
      if(cntalm) {sprintf(buff,"%11lu", cntalm); ShowText(buff, row++, col);}       
      if(cntgga) {sprintf(buff,"%11lu", cntgga); ShowText(buff, row++, col);}        
      if(cntgll) {sprintf(buff,"%11lu", cntgll); ShowText(buff, row++, col);}  
      if(cntgsa) {sprintf(buff,"%11lu", cntgsa); ShowText(buff, row++, col);} 
      if(cntgsv) {sprintf(buff,"%11lu", cntgsv); ShowText(buff, row++, col);} 
      if(cntrmc) {sprintf(buff,"%11lu", cntrmc); ShowText(buff, row++, col);}        
      if(cntvtg) {sprintf(buff,"%11lu", cntvtg); ShowText(buff, row++, col);}  
      if(cntzda) {sprintf(buff,"%11lu", cntzda); ShowText(buff, row++, col);} 
      if(cntalt) {sprintf(buff,"%11lu", cntalt); ShowText(buff, row++, col);} 
      if(cntbit) {sprintf(buff,"%11lu", cntbit); ShowText(buff, row++, col);}       
      if(cntcom) {sprintf(buff,"%11lu", cntcom); ShowText(buff, row++, col);} 
      if(cntdgp) {sprintf(buff,"%11lu", cntdgp); ShowText(buff, row++, col);}  
      if(cntinit){sprintf(buff,"%11lu",cntinit); ShowText(buff, row++, col);}  
      if(cntlog) {sprintf(buff,"%11lu", cntlog); ShowText(buff, row++, col);}  
      if(cntzch) {sprintf(buff,"%11lu", cntzch); ShowText(buff, row++, col);}  
      if(cnterr) {sprintf(buff,"%11lu", cnterr); ShowText(buff, row++, col);}  
      if(cntrid) {sprintf(buff,"%11lu", cntrid); ShowText(buff, row++, col);}  
      if(cntq)   {sprintf(buff,"%11lu",   cntq); ShowText(buff, row++, col);}
      if(cntftst){sprintf(buff,"%11lu",cntftst); ShowText(buff, row++, col);}
      if(cntgen) {sprintf(buff,"%11lu", cntgen); ShowText(buff, row++, col);}  
      if(cntibit){sprintf(buff,"%11lu",cntibit); ShowText(buff, row++, col);}  
      if(cnticom){sprintf(buff,"%11lu",cnticom); ShowText(buff, row++, col);}  
      if(cntidgp){sprintf(buff,"%11lu",cntidgp); ShowText(buff, row++, col);}  
      if(cntilog){sprintf(buff,"%11lu",cntilog); ShowText(buff, row++, col);}  
      if(cntipro){sprintf(buff,"%11lu",cntipro); ShowText(buff, row++, col);}  
      if(cntncs) {sprintf(buff,"%11lu", cntncs); ShowText(buff, row++, col);} 
   }
   else if(DataType == Z_BINARY){
      if(Cnt1000){sprintf(buff,"%11lu",Cnt1000); ShowText(buff, row++, col);}
      if(Cnt1001){sprintf(buff,"%11lu",Cnt1001); ShowText(buff, row++, col);}
      if(Cnt1002){sprintf(buff,"%11lu",Cnt1002); ShowText(buff, row++, col);}
      if(Cnt1003){sprintf(buff,"%11lu",Cnt1003); ShowText(buff, row++, col);}
      if(Cnt1005){sprintf(buff,"%11lu",Cnt1005); ShowText(buff, row++, col);}
      if(Cnt1007){sprintf(buff,"%11lu",Cnt1007); ShowText(buff, row++, col);}
      if(Cnt1008){sprintf(buff,"%11lu",Cnt1008); ShowText(buff, row++, col);}
      if(Cnt1009){sprintf(buff,"%11lu",Cnt1009); ShowText(buff, row++, col);}
      if(Cnt1011){sprintf(buff,"%11lu",Cnt1011); ShowText(buff, row++, col);}
      if(Cnt1012){sprintf(buff,"%11lu",Cnt1012); ShowText(buff, row++, col);}
      if(Cnt1040){sprintf(buff,"%11lu",Cnt1040); ShowText(buff, row++, col);}
      if(Cnt1041){sprintf(buff,"%11lu",Cnt1041); ShowText(buff, row++, col);}
      if(Cnt1042){sprintf(buff,"%11lu",Cnt1042); ShowText(buff, row++, col);}
      if(Cnt1050){sprintf(buff,"%11lu",Cnt1050); ShowText(buff, row++, col);}
      if(Cnt1051){sprintf(buff,"%11lu",Cnt1051); ShowText(buff, row++, col);}
      if(Cnt1070){sprintf(buff,"%11lu",Cnt1070); ShowText(buff, row++, col);}
      if(Cnt1071){sprintf(buff,"%11lu",Cnt1071); ShowText(buff, row++, col);}
      if(Cnt1072){sprintf(buff,"%11lu",Cnt1072); ShowText(buff, row++, col);}
      if(Cnt1075){sprintf(buff,"%11lu",Cnt1075); ShowText(buff, row++, col);}
      if(Cnt1090){sprintf(buff,"%11lu",Cnt1090); ShowText(buff, row++, col);}
      if(Cnt1091){sprintf(buff,"%11lu",Cnt1091); ShowText(buff, row++, col);}
      if(Cnt1092){sprintf(buff,"%11lu",Cnt1092); ShowText(buff, row++, col);}
      if(Cnt1100){sprintf(buff,"%11lu",Cnt1100); ShowText(buff, row++, col);}
      if(Cnt1102){sprintf(buff,"%11lu",Cnt1102); ShowText(buff, row++, col);}
      if(Cnt1106){sprintf(buff,"%11lu",Cnt1106); ShowText(buff, row++, col);}
      if(Cnt1108){sprintf(buff,"%11lu",Cnt1108); ShowText(buff, row++, col);}
      if(Cnt1110){sprintf(buff,"%11lu",Cnt1110); ShowText(buff, row++, col);}
      if(Cnt1117){sprintf(buff,"%11lu",Cnt1117); ShowText(buff, row++, col);}
      if(Cnt1130){sprintf(buff,"%11lu",Cnt1130); ShowText(buff, row++, col);}
      if(Cnt1135){sprintf(buff,"%11lu",Cnt1135); ShowText(buff, row++, col);}
      if(Cnt1136){sprintf(buff,"%11lu",Cnt1136); ShowText(buff, row++, col);}
      if(Cnt1137){sprintf(buff,"%11lu",Cnt1137); ShowText(buff, row++, col);}
      if(Cnt1150){sprintf(buff,"%11lu",Cnt1150); ShowText(buff, row++, col);}
      if(Cnt1160){sprintf(buff,"%11lu",Cnt1160); ShowText(buff, row++, col);}
      if(Cnt1170){sprintf(buff,"%11lu",Cnt1170); ShowText(buff, row++, col);}
      if(Cnt1171){sprintf(buff,"%11lu",Cnt1171); ShowText(buff, row++, col);}
      if(Cnt1172){sprintf(buff,"%11lu",Cnt1172); ShowText(buff, row++, col);}
      if(Cnt1173){sprintf(buff,"%11lu",Cnt1173); ShowText(buff, row++, col);}
      if(Cnt1180){sprintf(buff,"%11lu",Cnt1180); ShowText(buff, row++, col);}
      if(Cnt1190){sprintf(buff,"%11lu",Cnt1190); ShowText(buff, row++, col);}
      if(Cnt1191){sprintf(buff,"%11lu",Cnt1191); ShowText(buff, row++, col);}
//take out because of msgID changed 1192->1092      if(Cnt1192){sprintf(buff,"%11lu",Cnt1192); ShowText(buff, row++, col);}
      if(Cnt1200){sprintf(buff,"%11lu",Cnt1200); ShowText(buff, row++, col);}
      if(Cnt1208){sprintf(buff,"%11lu",Cnt1208); ShowText(buff, row++, col);}
      if(Cnt1210){sprintf(buff,"%11lu",Cnt1210); ShowText(buff, row++, col);}
      if(Cnt1211){sprintf(buff,"%11lu",Cnt1211); ShowText(buff, row++, col);}
      if(Cnt1212){sprintf(buff,"%11lu",Cnt1212); ShowText(buff, row++, col);}
      if(Cnt1213){sprintf(buff,"%11lu",Cnt1213); ShowText(buff, row++, col);}
      if(Cnt1214){sprintf(buff,"%11lu",Cnt1214); ShowText(buff, row++, col);}
      if(Cnt1216){sprintf(buff,"%11lu",Cnt1216); ShowText(buff, row++, col);}
      if(Cnt1217){sprintf(buff,"%11lu",Cnt1217); ShowText(buff, row++, col);}
      if(Cnt1218){sprintf(buff,"%11lu",Cnt1218); ShowText(buff, row++, col);}
      if(Cnt1219){sprintf(buff,"%11lu",Cnt1219); ShowText(buff, row++, col);}
      if(Cnt1220){sprintf(buff,"%11lu",Cnt1220); ShowText(buff, row++, col);}
      if(Cnt1240){sprintf(buff,"%11lu",Cnt1240); ShowText(buff, row++, col);}
      if(Cnt1270){sprintf(buff,"%11lu",Cnt1270); ShowText(buff, row++, col);}
      if(Cnt1292){sprintf(buff,"%11lu",Cnt1292); ShowText(buff, row++, col);}
      if(Cnt1300){sprintf(buff,"%11lu",Cnt1300); ShowText(buff, row++, col);}
      if(Cnt1303){sprintf(buff,"%11lu",Cnt1303); ShowText(buff, row++, col);}   
      if(Cnt1304){sprintf(buff,"%11lu",Cnt1304); ShowText(buff, row++, col);}   
      if(Cnt1306){sprintf(buff,"%11lu",Cnt1306); ShowText(buff, row++, col);}   
      if(Cnt1310){sprintf(buff,"%11lu",Cnt1310); ShowText(buff, row++, col);}
      if(Cnt1317){sprintf(buff,"%11lu",Cnt1317); ShowText(buff, row++, col);}
      if(Cnt1330){sprintf(buff,"%11lu",Cnt1330); ShowText(buff, row++, col);}
      if(Cnt1331){sprintf(buff,"%11lu",Cnt1331); ShowText(buff, row++, col);}   
      if(Cnt1334){sprintf(buff,"%11lu",Cnt1334); ShowText(buff, row++, col);}   
      if(Cnt1337){sprintf(buff,"%11lu",Cnt1337); ShowText(buff, row++, col);}   
      if(Cnt1350){sprintf(buff,"%11lu",Cnt1350); ShowText(buff, row++, col);}   
      if(Cnt1351){sprintf(buff,"%11lu",Cnt1351); ShowText(buff, row++, col);}   
      if(Cnt1360){sprintf(buff,"%11lu",Cnt1360); ShowText(buff, row++, col);}   
      if(Cnt1380){sprintf(buff,"%11lu",Cnt1380); ShowText(buff, row++, col);}
//take out because of msgID changed 1392->1292      if(Cnt1392){sprintf(buff,"%11lu",Cnt1392); ShowText(buff, row++, col);}
      if(CntZQry){sprintf(buff,"%11lu",CntZQry); ShowText(buff, row++, col);}
      if(CntZLog){sprintf(buff,"%11lu",CntZLog); ShowText(buff, row++, col);}   
   }
   if(cnthcs) {sprintf(buff,"%11lu", cnthcs); ShowText(buff, row++, col);}
   if(cntdcs) {sprintf(buff,"%11lu", cntdcs); ShowText(buff, row++, col);}
   if(cntovf) {sprintf(buff,"%11lu", cntovf); ShowText(buff, row++, col);}   
   if(cntsyn) {sprintf(buff,"%11lu", cntsyn); ShowText(buff, row++, col);}
}  
